VERSION 5.00
Begin VB.Form frmAbout 
   BackColor       =   &H00C0C000&
   BorderStyle     =   3  'Fixed Dialog
   Caption         =   "About Sony EVI-D30/D31 Camera Control Software"
   ClientHeight    =   4836
   ClientLeft      =   2340
   ClientTop       =   1932
   ClientWidth     =   5784
   ClipControls    =   0   'False
   BeginProperty Font 
      Name            =   "MS Sans Serif"
      Size            =   7.8
      Charset         =   0
      Weight          =   700
      Underline       =   0   'False
      Italic          =   0   'False
      Strikethrough   =   0   'False
   EndProperty
   Icon            =   "frmAbout.frx":0000
   LinkTopic       =   "Form2"
   MaxButton       =   0   'False
   MinButton       =   0   'False
   ScaleHeight     =   3329.464
   ScaleMode       =   0  'User
   ScaleWidth      =   5425.793
   ShowInTaskbar   =   0   'False
   StartUpPosition =   1  'CenterOwner
   Begin VB.TextBox Text1 
      Height          =   2292
      Left            =   240
      MultiLine       =   -1  'True
      ScrollBars      =   2  'Vertical
      TabIndex        =   5
      Text            =   "frmAbout.frx":0CCA
      Top             =   1440
      Width           =   5292
   End
   Begin VB.CommandButton cmdOK 
      Cancel          =   -1  'True
      Caption         =   "OK"
      Default         =   -1  'True
      Height          =   345
      Left            =   4245
      TabIndex        =   0
      Top             =   4320
      Width           =   1260
   End
   Begin VB.Label lblCopyright 
      BackColor       =   &H00C0C000&
      Caption         =   "Copyright  2002 - 2004 Joseph J. Janus"
      Height          =   492
      Left            =   360
      TabIndex        =   4
      Top             =   840
      Width           =   4092
   End
   Begin VB.Line Line1 
      BorderColor     =   &H00808080&
      BorderStyle     =   6  'Inside Solid
      Index           =   1
      X1              =   112.568
      X2              =   5290.711
      Y1              =   2643.743
      Y2              =   2643.743
   End
   Begin VB.Label lblTitle 
      BackColor       =   &H00C0C000&
      Caption         =   "Sony EVI-D30/D31 Camera Control Software"
      ForeColor       =   &H00000000&
      Height          =   360
      Left            =   360
      TabIndex        =   2
      Top             =   120
      Width           =   4092
   End
   Begin VB.Line Line1 
      BorderColor     =   &H00FFFFFF&
      BorderWidth     =   2
      Index           =   0
      X1              =   112.568
      X2              =   5290.711
      Y1              =   2643.743
      Y2              =   2643.743
   End
   Begin VB.Label lblVersion 
      BackColor       =   &H00C0C000&
      Caption         =   "Version 1.00.18 - October 9, 2004"
      Height          =   228
      Left            =   360
      TabIndex        =   3
      Top             =   480
      Width           =   4092
   End
   Begin VB.Label lblContact 
      BackColor       =   &H00C0C000&
      Caption         =   "Contact Information:"
      ForeColor       =   &H00000000&
      Height          =   828
      Left            =   252
      TabIndex        =   1
      Top             =   3948
      Width           =   3876
   End
End
Attribute VB_Name = "frmAbout"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = False
Attribute VB_PredeclaredId = True
Attribute VB_Exposed = False
Option Explicit

' Reg Key Security Options...
Const READ_CONTROL = &H20000
Const KEY_QUERY_VALUE = &H1
Const KEY_SET_VALUE = &H2
Const KEY_CREATE_SUB_KEY = &H4
Const KEY_ENUMERATE_SUB_KEYS = &H8
Const KEY_NOTIFY = &H10
Const KEY_CREATE_LINK = &H20
Const KEY_ALL_ACCESS = KEY_QUERY_VALUE + KEY_SET_VALUE + _
                       KEY_CREATE_SUB_KEY + KEY_ENUMERATE_SUB_KEYS + _
                       KEY_NOTIFY + KEY_CREATE_LINK + READ_CONTROL
                     
' Reg Key ROOT Types...
Const HKEY_LOCAL_MACHINE = &H80000002
Const ERROR_SUCCESS = 0
Const REG_SZ = 1                         ' Unicode nul terminated string
Const REG_DWORD = 4                      ' 32-bit number

Const gREGKEYSYSINFOLOC = "SOFTWARE\Microsoft\Shared Tools Location"
Const gREGVALSYSINFOLOC = "MSINFO"
Const gREGKEYSYSINFO = "SOFTWARE\Microsoft\Shared Tools\MSINFO"
Const gREGVALSYSINFO = "PATH"

Private Declare Function RegOpenKeyEx Lib "advapi32" Alias "RegOpenKeyExA" (ByVal hKey As Long, ByVal lpSubKey As String, ByVal ulOptions As Long, ByVal samDesired As Long, ByRef phkResult As Long) As Long
Private Declare Function RegQueryValueEx Lib "advapi32" Alias "RegQueryValueExA" (ByVal hKey As Long, ByVal lpValueName As String, ByVal lpReserved As Long, ByRef lpType As Long, ByVal lpData As String, ByRef lpcbData As Long) As Long
Private Declare Function RegCloseKey Lib "advapi32" (ByVal hKey As Long) As Long


Private Sub cmdSysInfo_Click()
  Call StartSysInfo
End Sub

Private Sub cmdOK_Click()
  Unload Me
End Sub

Private Sub Form_Load()
    Me.Caption = "About " & App.Title
    
    lblVersion.Caption = "Version " _
        & Form1.FormatVersion(App.Major, App.Minor, App.Revision)

    lblTitle.Caption = App.Title
    lblCopyright.Caption = "Copyright  2002-2005 Joseph J. Janus"
    lblContact.Caption = lblContact.Caption + vbCrLf + "Joseph J. Janus - j3soft@j3soft.com" + vbCrLf + "http://www.j3soft.com/webcam/evi-d31.htm"
    Text1.Text = Text1.Text + vbCrLf + "This program assumes that you have a Sony EVI-D30 or EVI-D31 camera connected through the standard VISCA cable to serial port 1 thru 8 of your computer." + vbCrLf + vbCrLf
    Text1.Text = Text1.Text + "There are arrow buttons for left, right, up, down, etc." + vbCrLf + vbCrLf
    Text1.Text = Text1.Text + "The blue arrows move the camera at the Pan and Tilt speed selected by the user." + vbCrLf + vbCrLf
    Text1.Text = Text1.Text + "Everything you need for basic control is in the source code." + vbCrLf + vbCrLf
    Text1.Text = Text1.Text + "The program can query the camera, so you can read the current camera settings and make the program respond accordingly. The AutoPan and Camera Number functions use camera inquiry and can be seen in the cInqPanTiltPos and cInqCamID subroutines in the source code. All you need is a little time and the VISCA controller documentation, readily available on the Web." + vbCrLf + vbCrLf
    Text1.Text = Text1.Text + "Information on the Sony EVI-D30 and EVI-D31 cameras can be found many places on the Internet. One such place is one of my pages located at:" + vbCrLf + vbCrLf
    Text1.Text = Text1.Text + "http://www.j3soft.com/webcam/evi-d31.htm" + vbCrLf + vbCrLf
    Text1.Text = Text1.Text + "How to use this program." + vbCrLf + vbCrLf
    Text1.Text = Text1.Text + "The first thing you must do is select the correct Comm Port that your camera is connected to, by clicking one of the Comm Port Option Buttons." + vbCrLf + vbCrLf
    Text1.Text = Text1.Text + "Then make sure you have the correct camera selected." + vbCrLf + vbCrLf
    Text1.Text = Text1.Text + "NOTE: The camera number switch has nothing to do with which camera is selected by this program." + vbCrLf + vbCrLf
    Text1.Text = Text1.Text + "The switch is only used to determine the camera number for use with the IR Remote Control." + vbCrLf + vbCrLf
    Text1.Text = Text1.Text + "Software camera selection is dependent on where the camera is located on the VISCA cable in relation to the computer controlling the camera." + vbCrLf + vbCrLf
    Text1.Text = Text1.Text + "For example, the first camera on the cable (nearest the computer) will be camera #1, the second camera on the cable away from the computer will be camera #2, etc." + vbCrLf + vbCrLf
    Text1.Text = Text1.Text + "This program can control up to 7 'Daisy Chained' cameras." + vbCrLf + vbCrLf
    Text1.Text = Text1.Text + "Then you can click the 'On' Command Button to turn your camera on if it isn't already on." + vbCrLf + vbCrLf
    Text1.Text = Text1.Text + "At this point you can use the standard buttons to control the camera's movement or zoom functions." + vbCrLf + vbCrLf
    Text1.Text = Text1.Text + "When you are finished using your camera you can click the 'Off' Command Button to turn off your camera." + vbCrLf + vbCrLf
    Text1.Text = Text1.Text + "If you are using multiple cameras and they aren't responding to the program's commands, try selecting the last active camera on the 'Daisy Chain' and clicking the 'Initialize' Command Button." + vbCrLf + vbCrLf
    Text1.Text = Text1.Text + "The Controls..." + vbCrLf
    Text1.Text = Text1.Text + "Directional Movement buttons move the camera in the direction the arrow points. Hold down the left mouse button to continue the camera movement. The speed of the Pan and Tilt movement can be selected below the directional arrows. The 'X' in the box moves the camera to the home position and adjusts the zoom to the midway position." + vbCrLf + vbCrLf
    Text1.Text = Text1.Text + "Zoom buttons move the lens from the wide angle to the telephoto end of travel and back. The buttons with the face on them move toward the telephoto end of travel and the buttons with the body on them move toward the wide angle end of travel. The zoom speed can be selected by the user." + vbCrLf + vbCrLf
    Text1.Text = Text1.Text + "Preset Functions numbered buttons Recall, Set or Reset the preset memories in the camera. Select Recall, Set or Reset (depending on what you want to do) then click the number of the memory you want that function to be performed on. The option will always return to recall so you don't accidentally Set or Reset a memory." + vbCrLf + vbCrLf
    Text1.Text = Text1.Text + "Scan Presets Start begins scanning the preset positions beginning with preset #1 going through preset #6 and starting at preset #1 again. You can select from 10 to 60 seconds, 1 to 60 minutes or 1 to 24 hours for how long the camera stops at each preset position before moving to the next position. The Return to Preset 1 checkbox allows you to set the scanning to return to preset #1 when scanning stops or to stay at the current preset position. Checking the box will make the camera return to preset 1 when the scanning stops. The Start button changes to a Stop button while scanning and the number of the preset position appears below the Stop button." + vbCrLf + vbCrLf
    Text1.Text = Text1.Text + "AutoPan 'Start' moves the camera to the left at the slowest pan speed, then returns it to the right at the highest pan speed, then starts moving to the left again. This is repeated until the 'Stop' button is clicked. Make any necessary camera settings prior to starting AutoPan." + vbCrLf + vbCrLf
    Text1.Text = Text1.Text + "The 'On' button turns the currently selected on while the 'Off' button turns the currently selected camera off." + vbCrLf + vbCrLf
    Text1.Text = Text1.Text + "Note: The power switch on the rear of the camera must be in the 'On' positin for the programs 'On' and 'Off' buttons to function." + vbCrLf + vbCrLf
    Text1.Text = Text1.Text + "Backlight 'On/Off' buttons turn the backlight function On or Off." + vbCrLf + vbCrLf
    Text1.Text = Text1.Text + "Date 'On/Off' buttons turn the date display function On or Off." + vbCrLf + vbCrLf
    Text1.Text = Text1.Text + "Time 'On/Off' buttons turn the time display function On or Off." + vbCrLf + vbCrLf
    Text1.Text = Text1.Text + "Focus: Auto sets the camera to the Automatic Focus mode, the Far and Near buttons will be grayed out. Manual sets the camera to manual focus, the Far and Near buttons will be enabled." + vbCrLf + vbCrLf
    Text1.Text = Text1.Text + "Help brings up this screen." + vbCrLf + vbCrLf
    Text1.Text = Text1.Text + "Exit ends the program." + vbCrLf + vbCrLf
    Text1.Text = Text1.Text + "Future versions of this program will incorporate more camera features and a version for use with Winnov Videum Video Capture Cards is planned." + vbCrLf + vbCrLf + vbCrLf
    Text1.Text = Text1.Text + "Comments, questions and suggestions may be sent to: j3soft@j3soft.com" + vbCrLf + vbCrLf + vbCrLf
    Text1.Text = Text1.Text + "This software is Freeware and is not to be charged for in any manner." + vbCrLf + vbCrLf + vbCrLf
    Text1.Text = Text1.Text + "DO NOT distribute this software with anything that is being sold on eBay or anywhere else!" + vbCrLf + vbCrLf + vbCrLf
    Text1.Text = Text1.Text + "As with any software, use this at your own risk. No warranty, of any kind, is expressed or implied."
End Sub

Public Sub StartSysInfo()
    On Error GoTo SysInfoErr
  
    Dim rc As Long
    Dim SysInfoPath As String
    
    ' Try To Get System Info Program Path\Name From Registry...
    If GetKeyValue(HKEY_LOCAL_MACHINE, gREGKEYSYSINFO, gREGVALSYSINFO, SysInfoPath) Then
    ' Try To Get System Info Program Path Only From Registry...
    ElseIf GetKeyValue(HKEY_LOCAL_MACHINE, gREGKEYSYSINFOLOC, gREGVALSYSINFOLOC, SysInfoPath) Then
        ' Validate Existance Of Known 32 Bit File Version
        If (Dir(SysInfoPath & "\MSINFO32.EXE") <> "") Then
            SysInfoPath = SysInfoPath & "\MSINFO32.EXE"
            
        ' Error - File Can Not Be Found...
        Else
            GoTo SysInfoErr
        End If
    ' Error - Registry Entry Can Not Be Found...
    Else
        GoTo SysInfoErr
    End If
    
    Call Shell(SysInfoPath, vbNormalFocus)
    
    Exit Sub
SysInfoErr:
    MsgBox "System Information Is Unavailable At This Time", vbOKOnly
End Sub

Public Function GetKeyValue(KeyRoot As Long, KeyName As String, SubKeyRef As String, ByRef KeyVal As String) As Boolean
    Dim i As Long                                           ' Loop Counter
    Dim rc As Long                                          ' Return Code
    Dim hKey As Long                                        ' Handle To An Open Registry Key
    Dim hDepth As Long                                      '
    Dim KeyValType As Long                                  ' Data Type Of A Registry Key
    Dim tmpVal As String                                    ' Tempory Storage For A Registry Key Value
    Dim KeyValSize As Long                                  ' Size Of Registry Key Variable
    '------------------------------------------------------------
    ' Open RegKey Under KeyRoot {HKEY_LOCAL_MACHINE...}
    '------------------------------------------------------------
    rc = RegOpenKeyEx(KeyRoot, KeyName, 0, KEY_ALL_ACCESS, hKey) ' Open Registry Key
    
    If (rc <> ERROR_SUCCESS) Then GoTo GetKeyError          ' Handle Error...
    
    tmpVal = String$(1024, 0)                             ' Allocate Variable Space
    KeyValSize = 1024                                       ' Mark Variable Size
    
    '------------------------------------------------------------
    ' Retrieve Registry Key Value...
    '------------------------------------------------------------
    rc = RegQueryValueEx(hKey, SubKeyRef, 0, _
                         KeyValType, tmpVal, KeyValSize)    ' Get/Create Key Value
                        
    If (rc <> ERROR_SUCCESS) Then GoTo GetKeyError          ' Handle Errors
    
    If (Asc(Mid(tmpVal, KeyValSize, 1)) = 0) Then           ' Win95 Adds Null Terminated String...
        tmpVal = Left(tmpVal, KeyValSize - 1)               ' Null Found, Extract From String
    Else                                                    ' WinNT Does NOT Null Terminate String...
        tmpVal = Left(tmpVal, KeyValSize)                   ' Null Not Found, Extract String Only
    End If
    '------------------------------------------------------------
    ' Determine Key Value Type For Conversion...
    '------------------------------------------------------------
    Select Case KeyValType                                  ' Search Data Types...
    Case REG_SZ                                             ' String Registry Key Data Type
        KeyVal = tmpVal                                     ' Copy String Value
    Case REG_DWORD                                          ' Double Word Registry Key Data Type
        For i = Len(tmpVal) To 1 Step -1                    ' Convert Each Bit
            KeyVal = KeyVal + Hex(Asc(Mid(tmpVal, i, 1)))   ' Build Value Char. By Char.
        Next
        KeyVal = Format$("&h" + KeyVal)                     ' Convert Double Word To String
    End Select
    
    GetKeyValue = True                                      ' Return Success
    rc = RegCloseKey(hKey)                                  ' Close Registry Key
    Exit Function                                           ' Exit
    
GetKeyError:      ' Cleanup After An Error Has Occured...
    KeyVal = ""                                             ' Set Return Val To Empty String
    GetKeyValue = False                                     ' Return Failure
    rc = RegCloseKey(hKey)                                  ' Close Registry Key
End Function

