VERSION 5.00
Object = "{5B5E2861-6554-11D0-B9B5-00A024FF8660}#1.0#0"; "WnvVidX.ocx"
Object = "{772D8C60-6294-11D0-B9B5-00A024FF8660}#1.2#0"; "WnvVideo.ocx"
Object = "{357C11E0-5C10-11D0-B9B4-00A024FF8660}#1.0#0"; "WnvInfo.ocx"
Begin VB.Form demo 
   BackColor       =   &H00C0C000&
   Caption         =   "Winnov Videum Video Display"
   ClientHeight    =   4452
   ClientLeft      =   60
   ClientTop       =   348
   ClientWidth     =   4224
   BeginProperty Font 
      Name            =   "MS Sans Serif"
      Size            =   7.8
      Charset         =   0
      Weight          =   700
      Underline       =   0   'False
      Italic          =   0   'False
      Strikethrough   =   0   'False
   EndProperty
   Icon            =   "Products.frx":0000
   LinkTopic       =   "Form1"
   MaxButton       =   0   'False
   ScaleHeight     =   4452
   ScaleWidth      =   4224
   StartUpPosition =   3  'Windows Default
   Begin WNVINFOLib.WnvInfo WnvInfo1 
      Height          =   612
      Left            =   2520
      TabIndex        =   5
      Top             =   960
      Visible         =   0   'False
      Width           =   852
      _Version        =   65536
      _ExtentX        =   1508
      _ExtentY        =   1085
      _StockProps     =   9
      BackColor       =   -2147483633
   End
   Begin VB.CommandButton hflip 
      Caption         =   "Horizontal Flip"
      Height          =   252
      Left            =   480
      TabIndex        =   4
      Top             =   3960
      Width           =   1455
   End
   Begin VB.CommandButton vflip 
      Caption         =   "Vertical Flip"
      Height          =   252
      Left            =   2280
      TabIndex        =   3
      Top             =   3960
      Width           =   1455
   End
   Begin WNVVIDXLib.WnvVidX WnvVidX1 
      Height          =   612
      Left            =   1200
      TabIndex        =   2
      Top             =   960
      Visible         =   0   'False
      Width           =   732
      _Version        =   65536
      _ExtentX        =   1296
      _ExtentY        =   1085
      _StockProps     =   9
      BackColor       =   -2147483633
   End
   Begin VB.CommandButton b3 
      Caption         =   "Next Source"
      Height          =   252
      Left            =   360
      TabIndex        =   1
      Top             =   240
      Width           =   1452
   End
   Begin WNVVIDEOLib.WnvVideo WnvVideo1 
      Height          =   2988
      Left            =   240
      TabIndex        =   0
      Top             =   840
      Width           =   3720
      _Version        =   65538
      _ExtentX        =   6562
      _ExtentY        =   5270
      _StockProps     =   65
      VideoCodec      =   " "
      VideoWidth      =   320
      VideoHeight     =   240
      StillWidth      =   200
      StillHeight     =   200
      EnableFrameEvents=   -1  'True
      EnableStillEvents=   -1  'True
   End
   Begin VB.Label lblSourceName 
      Alignment       =   2  'Center
      BackColor       =   &H00FFFFFF&
      BorderStyle     =   1  'Fixed Single
      Caption         =   "Composite"
      Height          =   252
      Left            =   2760
      TabIndex        =   6
      Top             =   240
      Width           =   1092
   End
   Begin VB.Line Line4 
      X1              =   120
      X2              =   4080
      Y1              =   720
      Y2              =   720
   End
   Begin VB.Line Line3 
      X1              =   4080
      X2              =   4080
      Y1              =   4320
      Y2              =   720
   End
   Begin VB.Line Line2 
      X1              =   120
      X2              =   4080
      Y1              =   4320
      Y2              =   4320
   End
   Begin VB.Line Line1 
      X1              =   120
      X2              =   120
      Y1              =   720
      Y2              =   4320
   End
   Begin VB.Line Line13 
      X1              =   120
      X2              =   4080
      Y1              =   600
      Y2              =   600
   End
   Begin VB.Line Line12 
      X1              =   4080
      X2              =   4080
      Y1              =   120
      Y2              =   600
   End
   Begin VB.Line Line11 
      X1              =   120
      X2              =   4080
      Y1              =   120
      Y2              =   120
   End
   Begin VB.Line Line10 
      X1              =   120
      X2              =   120
      Y1              =   120
      Y2              =   600
   End
End
Attribute VB_Name = "demo"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = False
Attribute VB_PredeclaredId = True
Attribute VB_Exposed = False
Dim VideoData() As Byte
Dim crossHair As Boolean
Dim Black As Boolean
Dim White As Boolean
Dim neg As Boolean
Dim threshold
Dim switchUV As Boolean
Dim grey As Boolean
Dim fun1 As Boolean
Dim fun2 As Boolean

Private Sub b3_Click()
    'switches to the next available video source
    Dim src
    src = WnvVidX1.GetNextSource
    If src = -6 Then 'handles case in which no more video sources remain
        src = WnvVidX1.GetFirstSource
    End If
    WnvVidX1.SetSource src
    Dim sname As String
    sname = WnvVidX1.GetSourceName(src)
    ' deal with ampersands
    Select Case sname
        Case "C&omposite":
            sname = "Composite"
        Case "&S-Video":
            sname = "S-Video"
        Case "M&XC":
            sname = "MXC"
    End Select
    lblSourceName = sname
End Sub

Private Sub Form_Load()
    Dim han
    han = WnvVideo1.Startup
    WnvVidX1.Startup han
    
    WnvVidX1.SetAutoWhiteBalance True
    WnvVidX1.SetAutoGain True
    WnvVideo1.VideoCodec = "RGBT"
    
    'set video source to first available source
    Dim src
    src = WnvVidX1.GetFirstSource
    'src = WnvVidX1.GetNextSource 'if you want to start with another source
    'src = WnvVidX1.GetNextSource 'if you want to start with another source
    WnvVidX1.SetSource src
    Dim sname As String
    sname = WnvVidX1.GetSourceName(src)
    Select Case sname 'eliminate ampersands for display purposes
        Case "C&omposite":
            sname = "Composite"
        Case "&S-Video":
            sname = "S-Video"
        Case "M&XC":
            sname = "MXC"
    End Select
    lblSourceName.Caption = sname
    Target = 0

End Sub

Private Sub Form_Unload(Cancel As Integer)
    WnvVideo1.Shutdown
    WnvVidX1.Shutdown
    Form1.cmdVideo.Caption = "Show Video"
End Sub

Private Sub hflip_Click()
    'flips video horizonatally
    If WnvVidX1.GetFlipHorizontal = False Then
        WnvVidX1.SetFlipHorizontal True
    Else
        WnvVidX1.SetFlipHorizontal False
    End If
End Sub
Private Sub vflip_Click()
    'flips video vertically
    If WnvVidX1.GetFlipVertical = False Then
        WnvVidX1.SetFlipVertical True
    Else
        WnvVidX1.SetFlipVertical False
    End If
    
End Sub

Private Sub WnvVideo1_VideoFrameCaptured(Data As Long, ByVal BufferLength As Long, ByVal BytesUsed As Long, ByVal TimeCaptured As Long, ByVal Flags As Long)
ReDim VideoData(BytesUsed - 1)
Dim i As Double

CopyMemory VarPtr(VideoData(0)), VarPtr(Data), BytesUsed

'////////////////////////////////////////////////////////////////////
'using RGBT

If WnvVideo1.VideoCodec = "RGBT" Then
''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''
'get rgb values
'VideoData(i) = 0        'blue
'VideoData(i + 1) = 0    'green
'VideoData(i + 2) = 0    'red
'''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''

''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''
'partial color extreme
If fun1 = True Then
    For i = 0 To BytesUsed - 1 Step 3
        If VideoData(i) >= VideoData(i + 1) And VideoData(i) >= _
        VideoData(i + 2) Then
            VideoData(i) = 255
        Else
            If VideoData(i + 1) >= VideoData(i) And VideoData(i + 1) >= _
            VideoData(i + 2) Then
                VideoData(i + 1) = 255
            Else
                If VideoData(i + 2) >= VideoData(i) And VideoData(i + 2) >= _
                VideoData(i + 1) Then
                    VideoData(i + 2) = 255
                End If
            End If
        End If
    Next i
End If

'''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''
'Complete color extreme
If fun2 = True Then
    For i = 0 To BytesUsed - 1 Step 3
        If VideoData(i) >= VideoData(i + 1) And VideoData(i) >= _
        VideoData(i + 2) Then
            VideoData(i) = 255
            VideoData(i + 1) = 0
            VideoData(i + 2) = 0
        Else
            If VideoData(i + 1) >= VideoData(i) And VideoData(i + 1) >= _
            VideoData(i + 2) Then
                VideoData(i) = 0
                VideoData(i + 1) = 255
                VideoData(i + 2) = 0
            Else
                If VideoData(i + 2) >= VideoData(i) And VideoData(i + 2) >= _
                VideoData(i + 1) Then
                    VideoData(i) = 0
                    VideoData(i + 1) = 0
                    VideoData(i + 2) = 255
                End If
            End If
        End If
    Next i
End If
End If

'//////////////////////////////////////////////////////////////////
'using YUY2
If WnvVideo1.VideoCodec = "YUY2" Then
''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''
'put black crosshair in center of frame(works)
If crossHair = True Then
    centerHeight = WnvVideo1.VideoHeight / 2
    centerWidth = WnvVideo1.VideoWidth / 2
    i = (centerHeight - 1) * (2 * WnvVideo1.VideoWidth) + (2 * centerWidth)
    VideoData(i) = 0 'center
    For j = 1 To 10 Step 1
        VideoData(i - 2 * j) = 0 'left
        VideoData(i + 2 * j) = 0 'right
        VideoData(i + 2 * j * WnvVideo1.VideoWidth) = 0 'above
        VideoData(i - 2 * j * WnvVideo1.VideoWidth) = 0 'below
    Next j
End If

''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''
'intensity thresholding
t = threshold
 
If Black = True Then
    If White = True Then
        For i = 0 To BytesUsed - 1 Step 2
            If neg = True Then
                If VideoData(i) > t Then
                    VideoData(i) = 0
                Else
                    VideoData(i) = 255
                End If
            Else
                If VideoData(i) < t Then
                     VideoData(i) = 0
                Else
                    VideoData(i) = 255
                End If
            End If
        Next i
    
    Else
        For i = 0 To BytesUsed - 1 Step 2
            If VideoData(i) < t Then
                 VideoData(i) = 0
            End If
        Next i
    End If
Else
    If White = True Then
        For i = 0 To BytesUsed - 1 Step 2
            If VideoData(i) >= t Then
                VideoData(i) = 255
            End If
        Next i
    End If
End If

''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''
'switch u and v values for each pixel
If switchUV = True Then
    Dim temp
    For i = 1 To BytesUsed - 1 Step 4
        temp = VideoData(i)
        VideoData(i) = VideoData(i + 2)
        VideoData(i + 2) = temp
    Next i
End If
''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''
'conversion to greyscale(works)
If grey = True Then
    For i = 1 To BytesUsed - 1 Step 2
        VideoData(i) = 128
    Next i
End If
End If
'/////////////////////////////////////////////////////////////////

CopyMemory VarPtr(Data), VarPtr(VideoData(0)), BytesUsed
End Sub
