Attribute VB_Name = "CommPortModule"
Public b0 As Byte, b1 As Byte, b2 As Byte, b3 As Byte
Public b4 As Byte, b5 As Byte, b6 As Byte, b7 As Byte
Public b8 As Byte, b9 As Byte, b10 As Byte, b11 As Byte
Public b12 As Byte, b13 As Byte, b14 As Byte, b15 As Byte
Public b16 As Byte, b17 As Byte, b18 As Byte, b20 As Byte
Public b21 As Byte, b22 As Byte, b26 As Byte, b27 As Byte
Public b2A As Byte, b2B As Byte, b30 As Byte, b33 As Byte
Public b36 As Byte, b38 As Byte, b3F As Byte, b47 As Byte

Public bCamNum As Byte, bFF As Byte, bI As Byte, bZ As Byte
Public bF As Byte, bB As Byte, bD As Byte

'Define Global Variables
Public gBacklight As Integer
Public gPanPos As String
Public iAutoPanState As Integer
Public gPanSpeedVal As Integer
Public gTiltSpeedVal As Integer
Public gZoomSpeedVal As Integer
Public gCamID As Variant
Public iDateState As Integer
Public iTimeState As Integer

Public Sub initBytes()
    b0 = &H0
    b1 = &H1
    b2 = &H2
    b3 = &H3
    b4 = &H4
    b5 = &H5
    b6 = &H6
    b7 = &H7
    b8 = &H8
    b9 = &H9
    b10 = &H10
    b11 = &H11
    b12 = &H12
    b13 = &H13
    b14 = &H14
    b15 = &H15
    b16 = &H16
    b17 = &H17
    b18 = &H18
    b20 = &H20
    b21 = &H21
    b22 = &H22
    b26 = &H26
    b27 = &H27
    b2A = &H2A
    b2B = &H2B
    b30 = &H30
    b33 = &H33
    b36 = &H36
    b38 = &H38
    b3F = &H3F
    b47 = &H47
    bCamNum = &H81      'Camera Number 1
    bFF = &HFF
    bI = &H88           'Broadcast
    bZ = &H21
    
    bA = &HA
    bB = &HB
    bC = &HC
    bD = &HD
    bE = &HE
    bF = &HF
End Sub

Public Sub stopC()
    Dim b(10) As Byte
    b(0) = bCamNum
    b(1) = b1
    b(2) = b6
    b(3) = b1
    b(4) = b10
    b(5) = b10
    b(6) = b3
    b(7) = b3
    b(8) = bFF
    b(9) = b0
    Form1.MSC.Output = b
End Sub

Public Sub cRightSlow()
    Dim b(10) As Byte
    b(0) = bCamNum
    b(1) = b1
    b(2) = b6
    b(3) = b1
    b(4) = gPanSpeedVal
    b(5) = gTiltSpeedVal
    b(6) = b2
    b(7) = b3
    b(8) = bFF
    b(9) = b0
    Form1.MSC.Output = b
End Sub

Public Sub cLeftSlow()
    Dim b(10) As Byte
    b(0) = bCamNum
    b(1) = b1
    b(2) = b6
    b(3) = b1
    b(4) = gPanSpeedVal
    b(5) = gTiltSpeedVal
    b(6) = b1
    b(7) = b3
    b(8) = bFF
    b(9) = b0
    Form1.MSC.Output = b
End Sub

Public Sub cCenter()
    Dim b(6) As Byte
    b(0) = bCamNum
    b(1) = b1
    b(2) = b6
    b(3) = b4
    b(4) = bFF
    b(5) = b0
    Form1.MSC.Output = b
End Sub

Public Sub cDownSlow()
    Dim b(10) As Byte
    b(0) = bCamNum
    b(1) = b1
    b(2) = b6
    b(3) = b1
    b(4) = gPanSpeedVal
    b(5) = gTiltSpeedVal
    b(6) = b3
    b(7) = b2
    b(8) = bFF
    b(9) = b0
    Form1.MSC.Output = b
End Sub

Public Sub cUpSlow()
    Dim b(10) As Byte
    b(0) = bCamNum
    b(1) = b1
    b(2) = b6
    b(3) = b1
    b(4) = gPanSpeedVal
    b(5) = gTiltSpeedVal
    b(6) = b3
    b(7) = b1
    b(8) = bFF
    b(9) = b0
    Form1.MSC.Output = b
End Sub

Public Sub cUpRightSlow()
    Dim b(10) As Byte
    b(0) = bCamNum
    b(1) = b1
    b(2) = b6
    b(3) = b1
    b(4) = gPanSpeedVal
    b(5) = gTiltSpeedVal
    b(6) = b2
    b(7) = b1
    b(8) = bFF
    b(9) = b0
    Form1.MSC.Output = b
End Sub

Public Sub cDownRightSlow()
    Dim b(10) As Byte
    b(0) = bCamNum
    b(1) = b1
    b(2) = b6
    b(3) = b1
    b(4) = gPanSpeedVal
    b(5) = gTiltSpeedVal
    b(6) = b2
    b(7) = b2
    b(8) = bFF
    b(9) = b0
    Form1.MSC.Output = b
End Sub

Public Sub cDownLeftSlow()
    Dim b(10) As Byte
    b(0) = bCamNum
    b(1) = b1
    b(2) = b6
    b(3) = b1
    b(4) = gPanSpeedVal
    b(5) = gTiltSpeedVal
    b(6) = b1
    b(7) = b2
    b(8) = bFF
    b(9) = b0
    Form1.MSC.Output = b
End Sub

Public Sub cUpLeftSlow()
    Dim b(10) As Byte
    b(0) = bCamNum
    b(1) = b1
    b(2) = b6
    b(3) = b1
    b(4) = gPanSpeedVal
    b(5) = gTiltSpeedVal
    b(6) = b1
    b(7) = b1
    b(8) = bFF
    b(9) = b0
    Form1.MSC.Output = b
End Sub

Public Sub cZoomIn()
    Dim b(7) As Byte
    b(0) = bCamNum
    b(1) = b1
    b(2) = b4
    b(3) = b7
    b(4) = b2
    b(5) = bFF
    b(6) = b0
    Form1.MSC.Output = b
End Sub

Public Sub cZoomOut()
    Dim b(7) As Byte
    b(0) = bCamNum
    b(1) = b1
    b(2) = b4
    b(3) = b7
    b(4) = b3
    b(5) = bFF
    b(6) = b0
    Form1.MSC.Output = b
End Sub

Public Sub cZoomStop()
    Dim b(7) As Byte
    b(0) = bCamNum
    b(1) = b1
    b(2) = b4
    b(3) = b7
    b(4) = b0
    b(5) = bFF
    b(6) = b0
    Form1.MSC.Output = b
End Sub

Public Sub cZoomInFast()
    Dim b(7) As Byte
    iZoomSpeed = &H2 + Hex(Asc(gZoomSpeedVal + 1))
    
    b(0) = bCamNum
    b(1) = b1
    b(2) = b4
    b(3) = b7
    b(4) = iZoomSpeed 'b26
    b(5) = bFF
    b(6) = b0
    Form1.MSC.Output = b
End Sub

Public Sub cZoomOutFast()
    Dim b(7) As Byte
    iZoomSpeed = &H12 + Hex(Asc(gZoomSpeedVal + 1))
    
    b(0) = bCamNum
    b(1) = b1
    b(2) = b4
    b(3) = b7
    b(4) = iZoomSpeed 'b36
    b(5) = bFF
    b(6) = b0
    Form1.MSC.Output = b
End Sub

Public Sub cPowerOn()
    Dim b(7) As Byte
    b(0) = bCamNum
    b(1) = b1
    b(2) = b4
    b(3) = b0
    b(4) = b2
    b(5) = bFF
    b(6) = b0
   Form1.MSC.Output = b
End Sub

Public Sub cPowerOff()
    Dim b(7) As Byte
    b(0) = bCamNum
    b(1) = b1
    b(2) = b4
    b(3) = b0
    b(4) = b3
    b(5) = bFF
    b(6) = b0
    Form1.MSC.Output = b
End Sub

Public Sub cPreset1()
'Recall Preset #1
    Dim b(8) As Byte
        b(0) = bCamNum
        b(1) = b1
        b(2) = b4
        b(3) = b3F
        b(4) = b2   'Recall
        b(5) = b0   'Preset 0-5 is Preset 1-6 in camera
        b(6) = bFF
        b(7) = b0
        Form1.MSC.Output = b
End Sub

Public Sub cPreset2()
'Recall Preset #2
    Dim b(8) As Byte
        b(0) = bCamNum
        b(1) = b1
        b(2) = b4
        b(3) = b3F
        b(4) = b2   'Recall
        b(5) = b1   'Preset 0-5 is Preset 1-6 in camera
        b(6) = bFF
        b(7) = b0
        Form1.MSC.Output = b
End Sub

Public Sub cPreset3()
'Recall Preset #3
    Dim b(8) As Byte
        b(0) = bCamNum
        b(1) = b1
        b(2) = b4
        b(3) = b3F
        b(4) = b2   'Recall
        b(5) = b2   'Preset 0-5 is Preset 1-6 in camera
        b(6) = bFF
        b(7) = b0
        Form1.MSC.Output = b
End Sub

Public Sub cPreset4()
'Recall Preset #4
    Dim b(8) As Byte
        b(0) = bCamNum
        b(1) = b1
        b(2) = b4
        b(3) = b3F
        b(4) = b2   'Recall
        b(5) = b3   'Preset 0-5 is Preset 1-6 in camera
        b(6) = bFF
        b(7) = b0
        Form1.MSC.Output = b
End Sub

Public Sub cPreset5()
'Recall Preset #5
    Dim b(8) As Byte
        b(0) = bCamNum
        b(1) = b1
        b(2) = b4
        b(3) = b3F
        b(4) = b2   'Recall
        b(5) = b4   'Preset 0-5 is Preset 1-6 in camera
        b(6) = bFF
        b(7) = b0
        Form1.MSC.Output = b
End Sub

Public Sub cPreset6()
'Recall Preset #6
    Dim b(8) As Byte
        b(0) = bCamNum
        b(1) = b1
        b(2) = b4
        b(3) = b3F
        b(4) = b2   'Recall
        b(5) = b5   'Preset 0-5 is Preset 1-6 in camera
        b(6) = bFF
        b(7) = b0
        Form1.MSC.Output = b
End Sub

Public Sub cSet1()
'Set Preset #1
    Dim b(8) As Byte
        b(0) = bCamNum
        b(1) = b1
        b(2) = b4
        b(3) = b3F
        b(4) = b1   'Set
        b(5) = b0   'Preset 0-5 is Preset 1-6 in camera
        b(6) = bFF
        b(7) = b0
        Form1.MSC.Output = b
End Sub

Public Sub cSet2()
'Set Preset #2
    Dim b(8) As Byte
        b(0) = bCamNum
        b(1) = b1
        b(2) = b4
        b(3) = b3F
        b(4) = b1   'Set
        b(5) = b1   'Preset 0-5 is Preset 1-6 in camera
        b(6) = bFF
        b(7) = b0
        Form1.MSC.Output = b
End Sub

Public Sub cSet3()
'Set Preset #3
    Dim b(8) As Byte
        b(0) = bCamNum
        b(1) = b1
        b(2) = b4
        b(3) = b3F
        b(4) = b1   'Set
        b(5) = b2   'Preset 0-5 is Preset 1-6 in camera
        b(6) = bFF
        b(7) = b0
        Form1.MSC.Output = b
End Sub

Public Sub cSet4()
'Set Preset #4
    Dim b(8) As Byte
        b(0) = bCamNum
        b(1) = b1
        b(2) = b4
        b(3) = b3F
        b(4) = b1   'Set
        b(5) = b3   'Preset 0-5 is Preset 1-6 in camera
        b(6) = bFF
        b(7) = b0
        Form1.MSC.Output = b
End Sub

Public Sub cSet5()
'Set Preset #5
    Dim b(8) As Byte
        b(0) = bCamNum
        b(1) = b1
        b(2) = b4
        b(3) = b3F
        b(4) = b1   'Set
        b(5) = b4   'Preset 0-5 is Preset 1-6 in camera
        b(6) = bFF
        b(7) = b0
        Form1.MSC.Output = b
End Sub

Public Sub cSet6()
'Set Preset #6
    Dim b(8) As Byte
        b(0) = bCamNum
        b(1) = b1
        b(2) = b4
        b(3) = b3F
        b(4) = b1   'Set
        b(5) = b5   'Preset 0-5 is Preset 1-6 in camera
        b(6) = bFF
        b(7) = b0
        Form1.MSC.Output = b
End Sub

Public Sub cReset1()
'Reset Preset #1
    Dim b(8) As Byte
        b(0) = bCamNum
        b(1) = b1
        b(2) = b4
        b(3) = b3F
        b(4) = b0   'Reset
        b(5) = b0   'Preset 0-5 is Preset 1-6 in camera
        b(6) = bFF
        b(7) = b0
        Form1.MSC.Output = b
End Sub

Public Sub cReset2()
'Reset Preset #2
    Dim b(8) As Byte
        b(0) = bCamNum
        b(1) = b1
        b(2) = b4
        b(3) = b3F
        b(4) = b0   'Reset
        b(5) = b1   'Preset 0-5 is Preset 1-6 in camera
        b(6) = bFF
        b(7) = b0
        Form1.MSC.Output = b
End Sub

Public Sub cReset3()
'Reset Preset #3
    Dim b(8) As Byte
        b(0) = bCamNum
        b(1) = b1
        b(2) = b4
        b(3) = b3F
        b(4) = b0   'Reset
        b(5) = b2   'Preset 0-5 is Preset 1-6 in camera
        b(6) = bFF
        b(7) = b0
        Form1.MSC.Output = b
End Sub

Public Sub cReset4()
'Reset Preset #4
    Dim b(8) As Byte
        b(0) = bCamNum
        b(1) = b1
        b(2) = b4
        b(3) = b3F
        b(4) = b0   'Reset
        b(5) = b3   'Preset 0-5 is Preset 1-6 in camera
        b(6) = bFF
        b(7) = b0
        Form1.MSC.Output = b
End Sub

Public Sub cReset5()
'Reset Preset #5
    Dim b(8) As Byte
        b(0) = bCamNum
        b(1) = b1
        b(2) = b4
        b(3) = b3F
        b(4) = b0   'Reset
        b(5) = b4   'Preset 0-5 is Preset 1-6 in camera
        b(6) = bFF
        b(7) = b0
        Form1.MSC.Output = b
End Sub

Public Sub cReset6()
'Reset Preset #6
    Dim b(7) As Byte
        b(0) = bCamNum
        b(1) = b1
        b(2) = b4
        b(3) = b3F
        b(4) = b0   'Reset
        b(5) = b5   'Preset 0-5 is Preset 1-6 in camera
        b(6) = bFF
        Form1.MSC.Output = b
End Sub

Public Sub cBacklightOn()
'Turn Backlight ON
    Dim b(7) As Byte
        b(0) = bCamNum
        b(1) = b1
        b(2) = b4
        b(3) = b33
        b(4) = b2
        b(5) = bFF
        b(6) = b0
        Form1.MSC.Output = b
End Sub

Public Sub cBacklightOff()
'Turn Backlight OFF
    Dim b(7) As Byte
        b(0) = bCamNum
        b(1) = b1
        b(2) = b4
        b(3) = b33
        b(4) = b3
        b(5) = bFF
        b(6) = b0
        Form1.MSC.Output = b
End Sub

Public Sub cAddressSet()
'Send Address Set Command to Cameras
    Dim b(5) As Byte
        b(0) = bI
        b(1) = b30
        b(2) = b1
        b(3) = bFF
        b(4) = b0
        Form1.MSC.Output = b
End Sub

Public Sub cIF_Clear()
'Send IF_Clear Command to Cameras
    Dim b(6) As Byte
        b(0) = bI
        b(1) = b1
        b(2) = b0
        b(3) = b1
        b(4) = bFF
        b(6) = b0
        Form1.MSC.Output = b
End Sub

Public Sub cZoomCenter()
    Dim b(10) As Byte
        b(0) = bCamNum
        b(1) = b1
        b(2) = b4
        b(3) = b47
        b(4) = b0
        b(5) = b2
        b(6) = b0
        b(7) = b0
        b(8) = bFF
        b(9) = b0
        Form1.MSC.Output = b
End Sub

Public Sub cFocusFar()
    Dim b(7) As Byte
        b(0) = bCamNum
        b(1) = b1
        b(2) = b4
        b(3) = b8
        b(4) = b2
        b(5) = bFF
        b(6) = b0
        Form1.MSC.Output = b
End Sub

Public Sub cFocusNear()
    Dim b(7) As Byte
        b(0) = bCamNum
        b(1) = b1
        b(2) = b4
        b(3) = b8
        b(4) = b3
        b(5) = bFF
        b(6) = b0
        Form1.MSC.Output = b
End Sub

Public Sub cFocusManual()
    Dim b(7) As Byte
        b(0) = bCamNum
        b(1) = b1
        b(2) = b4
        b(3) = b38
        b(4) = b3
        b(5) = bFF
        b(6) = b0
        Form1.MSC.Output = b
End Sub

Public Sub cFocusAuto()
    Dim b(7) As Byte
        b(0) = bCamNum
        b(1) = b1
        b(2) = b4
        b(3) = b38
        b(4) = b2
        b(5) = bFF
        b(6) = b0
        Form1.MSC.Output = b
End Sub

Public Sub cFocusStop()
    Dim b(7) As Byte
        b(0) = bCamNum
        b(1) = b1
        b(2) = b4
        b(3) = b8
        b(4) = b0
        b(5) = bFF
        b(6) = b0
        Form1.MSC.Output = b
End Sub

Public Sub cAutoPanLeft()
    Dim b(10) As Byte
    b(0) = bCamNum
    b(1) = b1
    b(2) = b6
    b(3) = b1
    b(4) = b1
    b(5) = b1
    b(6) = b1
    b(7) = b3
    b(8) = bFF
    b(9) = b0
    Form1.MSC.Output = b
    
    iAutoPanState = 1
End Sub

Public Sub cAutoPanRight()
    Dim b(10) As Byte
    b(0) = bCamNum
    b(1) = b1
    b(2) = b6
    b(3) = b1
    b(4) = b18
    b(5) = b1
    b(6) = b2
    b(7) = b3
    b(8) = bFF
    b(9) = b0
    Form1.MSC.Output = b
End Sub

Public Sub cInqPanTiltPos()
'Check Pan and Tilt Positions
    Dim vBuffer As Variant
    Dim sPanPosTemp As String
    Dim i As Integer
    Dim b(6) As Byte
        b(0) = bCamNum
        b(1) = b9
        b(2) = b6
        b(3) = b12
        b(4) = bFF
        b(5) = b0
        Form1.MSC.Output = b
        
        Form1.Wait (0.25)   'Wait 1/4 Second
        ' Set InputMode to read text data
        Form1.MSC.InputMode = comInputModeText

        ' Retrieve all available data.
        Form1.MSC.InputLen = 0
        
        gPanPos = ""
        
        If Form1.MSC.InBufferCount >= 11 Then   '#of bytes in return
        ' Store Text data in buffer
            vBuffer = Form1.MSC.Input
            For i = 1 To 4
                gPanPosTemp = Hex(Asc(Mid$(vBuffer, (2 + i), 1)))
                gPanPos = gPanPos + gPanPosTemp
            Next i
        End If
End Sub

Public Sub cInqBacklight()
'Check status of Backlight function
    Dim vBuffer As Variant
    Dim b(6) As Byte
        b(0) = bCamNum
        b(1) = b9
        b(2) = b4
        b(3) = b33
        b(4) = bFF
        b(5) = b0
        Form1.MSC.Output = b
        
        Form1.Wait (0.25)   'Wait 1/4 Second
        ' Set InputMode to read text data
        Form1.MSC.InputMode = comInputModeText

        ' Retrieve all available data.
        Form1.MSC.InputLen = 0

        ' Store Text data in buffer
        If Form1.MSC.InBufferCount >= 4 Then '# of bytes in return
            vBuffer = Form1.MSC.Input
            gBacklight = Asc(Mid$(vBuffer, 3, 1))
        End If
End Sub

Public Sub cCancel()
    Dim b(4) As Byte
        b(0) = bCamNum
        b(1) = b20
        b(2) = bFF
        b(3) = b0
        Form1.MSC.Output = b
        
        Form1.Wait (0.25)
        b(0) = bCamNum
        b(1) = b21
        b(2) = bFF
        b(3) = b0
        Form1.MSC.Output = b
End Sub

Public Sub cDateOn()
    Dim b(7) As Byte
        b(0) = bCamNum
        b(1) = b1
        b(2) = b7
        b(3) = b2A
        b(4) = b2
        b(5) = bFF
        b(6) = b0
        Form1.MSC.Output = b
End Sub

Public Sub cDateOff()
    Dim b(7) As Byte
        b(0) = bCamNum
        b(1) = b1
        b(2) = b7
        b(3) = b2A
        b(4) = b3
        b(5) = bFF
        b(6) = b0
        Form1.MSC.Output = b
End Sub

Public Sub cTimeOff()
    Dim b(7) As Byte
        b(0) = bCamNum
        b(1) = b1
        b(2) = b7
        b(3) = b2B
        b(4) = b3
        b(5) = bFF
        b(6) = b0
        Form1.MSC.Output = b
End Sub

Public Sub cTimeOn()
    Dim b(7) As Byte
        b(0) = bCamNum
        b(1) = b1
        b(2) = b7
        b(3) = b2B
        b(4) = b2
        b(5) = bFF
        b(6) = b0
        Form1.MSC.Output = b
End Sub

Public Sub cInqCamID()
    Dim b(6) As Byte
    Dim gCamIDTemp As String
    Dim vBuffer As Variant
    Dim i As Integer

        b(0) = bCamNum
        b(1) = b9
        b(2) = b4
        b(3) = b22
        b(4) = bFF
        b(5) = b0
        Form1.MSC.Output = b
        
        Form1.Wait (0.25)   'Wait 1/4 Second
        ' Set InputMode to read text data
        Form1.MSC.InputMode = comInputModeText

        ' Retrieve all available data.
        Form1.MSC.InputLen = 0
                  
        gCamID = 0
        
        If Form1.MSC.InBufferCount >= 5 Then   '#of bytes in return
        ' Store Text data in buffer
            vBuffer = Form1.MSC.Input
            For i = 1 To 2
                gCamIDTemp = Asc(Mid$(vBuffer, (2 + i), 1))
                gCamID = gCamID & gCamIDTemp
            Next i
        Else
            gCamID = -1
        End If
        
End Sub

Public Sub cAbsolute()
    Dim b(16) As Byte
        b(0) = bCamNum
        b(1) = b1
        b(2) = b6
        b(3) = b2
        b(4) = gPanSpeedVal
        b(5) = gTiltSpeedVal
        b(6) = bF
        b(7) = bF
        b(8) = bF
        b(9) = bF
        b(10) = b0
        b(11) = b0
        b(12) = b0
        b(13) = b0
        b(14) = bFF
        b(15) = b0
        Form1.MSC.Output = b
End Sub

Public Sub cRelative()
    Dim b(16) As Byte
        b(0) = bCamNum
        b(1) = b1
        b(2) = b6
        b(3) = b3
        b(4) = gPanSpeedVal
        b(5) = gTiltSpeedVal
        b(6) = bF
        b(7) = bF
        b(8) = bB
        b(9) = bB
        b(10) = bF
        b(11) = bF
        b(12) = bF
        b(13) = b3
        b(14) = bFF
        b(15) = b0
        Form1.MSC.Output = b
End Sub
